/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.launch.hscmgt;

import com.ibm.hsc.common.util.AusEventText;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.AusSystemEventLog;
import com.ibm.hsc.common.util.Crypt;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.launch.hscmgt.BackupException;
import com.ibm.hwmca.common.log.ClassLogInfo;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.RemoteException;

public class Backup {
    private static final String TRACE_MASKD = "JBACKUPD";
    private static final String TRACE_MASKF = "JBACKUPF";
    private static final String TRACE_MASKT = "JBACKUPT";
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, 100, "Backup");
    private static final short ERRID_0001 = 1;
    private static final short ERRID_0002 = 2;
    public static final String BACKUP_SCRIPT = "/opt/hsc/bin/backuphdr";
    private static final String HSC_DO_CMD_EXECUTABLE = "/opt/hsc/bin/hscdc";

    public static void backup() throws RemoteException {
        Trace.trace(TRACE_MASKT, "-> Backup.backup()");
        try {
            Trace.trace(TRACE_MASKF, "shell script executed =/opt/hsc/bin/hscdc /opt/hsc/bin/backuphdr");
            EExecResult eExecResult = EExec.Exec((String)("/opt/hsc/bin/hscdc " + Crypt.encrypt(BACKUP_SCRIPT)));
            if (eExecResult.rc != 0) {
                String string;
                Trace.trace(TRACE_MASKF, "backup request failed");
                Trace.trace(TRACE_MASKF, "backup exit value =" + eExecResult.rc);
                switch (eExecResult.rc) {
                    case 4: {
                        string = "0004";
                        break;
                    }
                    case 5: {
                        string = "0002";
                        break;
                    }
                    default: {
                        string = "0003";
                        AusMicrocodeLog ausMicrocodeLog = new AusMicrocodeLog(_logInfo, 0, 1, eExecResult.rc, null);
                        String string2 = Backup.getLogFile("/var/hsc/log/backuphdr.log");
                        if (string2 != null) {
                            ausMicrocodeLog.add(string2);
                        }
                        ausMicrocodeLog.add("The backup request completed with a bad return code = " + eExecResult.rc + ".");
                        ausMicrocodeLog.writeEntry(null);
                    }
                }
                throw new BackupException(string);
            }
            Trace.trace(TRACE_MASKF, "backup request successful");
            AusSystemEventLog ausSystemEventLog = new AusSystemEventLog(new AusEventText(2062), "BackupCrit");
            ausSystemEventLog.writeEntry();
        }
        catch (BackupException backupException) {
            throw backupException;
        }
        catch (Throwable throwable) {
            new AusMicrocodeLog(_logInfo, 2, throwable).writeEntry(null);
            throw new BackupException("0003");
        }
        Trace.trace(TRACE_MASKT, "<- Backup.backup()");
    }

    private static String getLogFile(String string) {
        Trace.trace(TRACE_MASKT, "-> Backup.getLogFile()");
        String string2 = null;
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            string2 = new String(byArray);
        }
        catch (Throwable throwable) {
            Trace.trace(TRACE_MASKF, "The requested log file: " + string + " could not be read.");
        }
        Trace.trace(TRACE_MASKT, "<- Backup.getLogFile()");
        return string2;
    }
}

